from bpy.types import PropertyGroup
from bpy.props import FloatProperty, IntProperty, BoolProperty, EnumProperty


class ActiveColliderAnimationProps(PropertyGroup):

    """ Propiedades guardadas en el active_collider.animation.x """

    permeability_start: IntProperty(name="Start", description="Start at Frame", default=1)
    permeability_duration: IntProperty(name="Duration", description="Duration", default=10)
    permeability_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    permeability_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    permeability_from: FloatProperty(name="From", description="From value x", default=0.04)
    permeability_to: FloatProperty(name="To", description="To value x", default=0.0001)
    permeability_animed: BoolProperty(default=False)
    permeability_inc_dec: BoolProperty(default=False)

    stickiness_start: IntProperty(name="Start", description="Start at Frame", default=1)
    stickiness_duration: IntProperty(name="Duration", description="Duration", default=10)
    stickiness_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    stickiness_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    stickiness_from: FloatProperty(name="From", description="From value x", default=0.04)
    stickiness_to: FloatProperty(name="To", description="To value x", default=0.0001)
    stickiness_animed: BoolProperty(default=False)
    stickiness_inc_dec: BoolProperty(default=False)

    damping_factor_start: IntProperty(name="Start", description="Start at Frame", default=1)
    damping_factor_duration: IntProperty(name="Duration", description="Duration", default=10)
    damping_factor_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    damping_factor_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    damping_factor_from: FloatProperty(name="From", description="From value x", default=0.04)
    damping_factor_to: FloatProperty(name="To", description="To value x", default=0.0001)
    damping_factor_animed: BoolProperty(default=False)
    damping_factor_inc_dec: BoolProperty(default=False)
    
    friction_factor_start: IntProperty(name="Start", description="Start at Frame", default=1)
    friction_factor_duration: IntProperty(name="Duration", description="Duration", default=10)
    friction_factor_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    friction_factor_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    friction_factor_from: FloatProperty(name="From", description="From value x", default=0.04)
    friction_factor_to: FloatProperty(name="To", description="To value x", default=0.0001)
    friction_factor_animed: BoolProperty(default=False)
    friction_factor_inc_dec: BoolProperty(default=False)

    enable_disable_start: IntProperty(name="Start", description="Start at Frame", default=1)
    enable_disable_from_to: EnumProperty(
        items=[
            ('ON_OFF', "On to Off", "", 0),
            ('OFF_ON', "Off to On", "", 1),
        ]
    )
    enable_disable_animed: BoolProperty(default=False)